type Escalar 	= Float
data Vector 	= MkVec [Escalar] deriving Show
type Fila       = [Escalar]
data Matriz	= MkMat [Fila] deriving Show


m1 :: Matriz
m1 = MkMat [[1.0, 2.0, 3.0 ],
            [4.0, 5.0, 6.0 ]]
            
v1 :: Vector
v1 = MkVec [10.0, 20.0, 30.0]            

---------
-- B --
---------
mapMat :: (Escalar -> Escalar) -> Matriz -> Matriz
mapMat f (MkMat xss) = MkMat (map (map f) xss)

---------
-- A --
---------

negarMat :: Matriz -> Matriz
negarMat = mapMat (*(-1.0))

porMat :: Escalar -> Matriz -> Matriz
porMat k = mapMat (*k)

esMat :: Matriz -> Bool
esMat (MkMat [])  = False
esMat (MkMat xss) = todosIguales (map length xss)
  where todosIguales []     = True
        todosIguales (l:ls) = and [ y==l | y<-ls]

---------
-- C --
---------

porMixto :: Matriz -> Vector -> Vector
porMixto m@(MkMat fss) v@(MkVec es) 
  | not (esMat m)   = error "Matriz no valida"
  | cols m /= dim v = error "Matriz y vector no compatibles"
  | otherwise       = MkVec (map (\fs -> sum (zipWith (*) fs es)) fss)
    where cols (MkMat (f1:fss)) = length f1
          dim  (MkVec es)       = length es


sumMat :: Matriz -> Matriz -> Matriz
sumMat m1@(MkMat xss) m2@(MkMat yss)
  | not (esMat m1 && esMat m2) = error "Matriz no valida"
  | dim m1 /= dim m2           = error "Matrices incompatibles"
  | otherwise                  = MkMat (zipWith (zipWith (+)) xss yss)
    where dim (MkMat fss) = (length fss, length (head fss))

---------
-- D --
---------
    
foldMat :: (Fila -> a -> a) -> a -> Matriz -> a        
foldMat f e (MkMat fss) = foldr f e fss

mayorMod :: Matriz -> Fila
mayorMod = foldMat f []
  where f fs mayorFs = if modulo fs > modulo mayorFs then fs else mayorFs
        modulo = sum . map (^2)
